﻿using System;
using System.Collections.Generic;
using PpmsDataService.VA.PPMS.Context;

namespace PpmsDataService.ModelsEnumTypes
{
    public enum RelationshipType
    {
        Choice = 1,
        PC3 = 2,
        VA = 3,
        DoD = 4,
        IHS = 5,
        AcademicAffiliate = 6,
        FederallyQualifiedHealthCenter = 7,
        Network = 8,
        NonLicensensedPractitioner = 9,
        TribalHealthPlan = 10
    }

    public struct RelationshipTypeId
    {
        public RelationshipTypeId(int number, int value, string name) : this()
        {
            Number = number;
            Value = value;
            Name = name;
        }

        public int Number { get; }
        public int Value { get; }
        public string Name { get; }
    }

    public class RelationshipTypeIds
    {
        private static List<RelationshipTypeId> _relationshipTypeIds;
        static RelationshipTypeIds()
        {
            _relationshipTypeIds = new List<RelationshipTypeId>();
            _relationshipTypeIds.Add(new RelationshipTypeId(1, 767940008, "Choice"));
            _relationshipTypeIds.Add(new RelationshipTypeId(2, 767940009, "PC3"));
            _relationshipTypeIds.Add(new RelationshipTypeId(3, 767940000, "VA"));
            _relationshipTypeIds.Add(new RelationshipTypeId(4, 767940001, "DoD"));
            _relationshipTypeIds.Add(new RelationshipTypeId(5, 767940002, "IHS"));
            _relationshipTypeIds.Add(new RelationshipTypeId(6, 767940003, "AcademicAffiliate"));
            _relationshipTypeIds.Add(new RelationshipTypeId(7, 767940004, "FederallyQualifiedHealthCenter"));
            _relationshipTypeIds.Add(new RelationshipTypeId(8, 767940005, "Network"));
            _relationshipTypeIds.Add(new RelationshipTypeId(9, 767940006, "NonLicensensedPractitioner"));
            _relationshipTypeIds.Add(new RelationshipTypeId(10, 767940007, "TribalHealthPlan"));
        }

        public static RelationshipTypeId GetRelationshipType(int number)
        {
            return _relationshipTypeIds.Find(n => n.Number == number);
        }

        public static RelationshipTypeId GetRelationshipType(string name)
        {
            return _relationshipTypeIds.Find(n => n.Name == name);
        }
    }
}